package furny;

import furny.ga.FurnLayoutIndividual;
import furny.ga.util.Distance;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.evaluation.IFitnessEvaluator;
import ga.core.validation.GAContext;

public class FurnLayoutEvaluator implements
    IFitnessEvaluator<FurnLayoutIndividual> {

  private final FurnLayoutIndividual targetIndividual = new FurnLayoutIndividual();
  private final GAContext context;

  public FurnLayoutEvaluator(final String genotype, final GAContext context) {
    FurnLayoutIOUtil.parse(targetIndividual, genotype);
    targetIndividual.setContext(context);
    this.context = context;
  }

  @Override
  public void evaluate(final FurnLayoutIndividual individual) {
    final float fitness = (1f - Distance.calcDistance2(targetIndividual,
        individual, context)) * 100f;

    individual.setFitness(fitness);
  }

  public FurnLayoutIndividual getTargetIndividual() {
    return targetIndividual;
  }
}
